# 公共资源目录说明

此目录包含应用程序的公共静态资源，这些资源会在构建时直接复制到输出目录，可通过绝对路径访问。

## 目录结构

### assets/
- textures/: 存放纹理资源文件，用于3D场景渲染

### logo.ico
- 应用程序的图标文件，显示在浏览器标签页和任务栏

## 功能说明
- 提供应用程序运行所需的公共静态资源
- 存储不会通过webpack处理的资源文件
- 支持在HTML中通过绝对路径直接引用

## 使用方式
在HTML或JavaScript中通过绝对路径引用公共资源：
```html
<!-- 在HTML中引用 -->
<link rel="icon" type="image/x-icon" href="/logo.ico">

<!-- 在JavaScript中引用 -->
const textureUrl = '/assets/textures/example.png';
```

## 注意事项
- 公共资源不会经过webpack的处理和优化
- 文件名中不应包含特殊字符，建议使用小写字母、数字和连字符
- 对于需要通过webpack处理的资源，请放在src/assets目录下